%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_2point_cal_corr
%
% Scope:    plot overview figure 2-point calibration (delta-values)
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell),
%           cal gas 1 name (string),
%           true values cal gas 1 (double),
%           cal gas 2 name (string),
%           true values cal gas 2 (double),
%           index of "target" variables that are being corrected (double)
%           index of cal gas 1 (double)
%           index of cal gas 2 (double)
%           slope of linear fit (double)
%           plot title (string)
%
% Output:   overview figure 2-point calibration correction (delta-values)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_2point_cal_corr(data,bindata,binref,gasnames,true_gas1,true_values1,true_gas2,true_values2,target_idx,ind_gas1,ind_gas2,sssplot,titlename)

figure;
for z=1:width(target_idx)
    subplot(3,2,2*z-1);
    hold on;
    for i=1:width(gasnames)
    scatter(bindata.(gasnames{1,i})(:,1),bindata.(gasnames{1,i})(:,target_idx(1,z)),10);
    end
    errorbar(binref.mean(:,1),binref.mean(:,target_idx(1,z)),binref.std(:,target_idx(1,z)),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','none','linewidth',1.2);
    grid on;
    box on;
    xlim([0 data.all(end,1)-bindata.start_time]);
    xlabel('Time [h]','fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    if z==1
        lll=cell(1,width(gasnames));
        for n=1:width(gasnames)
            lll{n} = string(gasnames{1,n}); end
        legend(lll,'location','northeast');
        title({sprintf('%s',titlename)});
    end
   
    subplot(3,2,2*z);
    scatter(repelem(true_values1(1,z),height(bindata.(gasnames{1,ind_gas1}))),bindata.(gasnames{1,ind_gas1})(:,target_idx(1,z)),'marker','o','markeredgecolor',[0.7 0.7 0.7],'handlevisibility','off');
    hold on;
    scatter(repelem(true_values2(1,z),height(bindata.(gasnames{1,ind_gas2}))),bindata.(gasnames{1,ind_gas2})(:,target_idx(1,z)),'marker','o','markeredgecolor',[0.3010 0.7450 0.9330],'handlevisibility','off');
    errorbar(true_values1(1,z),binref.(gasnames{1,ind_gas1})(1,target_idx(1,z)),binref.(gasnames{1,ind_gas1})(2,target_idx(1,z)),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','k','linewidth',1.5);
    errorbar(true_values2(1,z),binref.(gasnames{1,ind_gas2})(1,target_idx(1,z)),binref.(gasnames{1,ind_gas2})(2,target_idx(1,z)),'marker','o','linestyle','none','color','b','markeredgecolor','b','markerfacecolor','b','linewidth',1.5);
    plot([min(true_values1(1,z)) max(true_values2(1,z))],sssplot(z,1)*[min(true_values1(1,z)) max(true_values2(1,z))]+sssplot(z,2),'-r');
    plot([min(true_values1(1,z)) max(true_values2(1,z))],[min(true_values1(1,z)) max(true_values2(1,z))],'--k');
    grid on;
    box on;
    xlabel({sprintf('%s reference',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    ylabel({sprintf('%s measured',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    if z==1
    legend(sprintf('%s',true_gas1),sprintf('%s',true_gas2),'linear fit','1:1 agreement','location','northwest','fontsize',10); end    
end

    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);

end

